﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ComfileTech.ComfilePi.IO
{
    public class AnalogInput
    {
        public enum ChannelID
        {
            A0 = ADS1115.ChannelBits.b00,
            A1 = ADS1115.ChannelBits.b01,
            A2 = ADS1115.ChannelBits.b10,
            A3 = ADS1115.ChannelBits.b11
        }
        public AnalogInput(ADS1115 i2c, ChannelID channel)
        {
            _i2c = i2c;
            _channel = channel;
        }

        readonly ADS1115 _i2c;
        readonly ChannelID _channel;
        public ChannelID Channel => _channel;

        public void ScheduleRead()
        {
            _i2c.ScheduleRead((ADS1115.ChannelBits)_channel);
        }

        public bool IsReady()
        {
            return _i2c.IsReady();
        }

        public ushort ReadValue()
        {
            return _i2c.ReadValue();
        }

        public ushort Read()
        {
            return _i2c.Read((ADS1115.ChannelBits)_channel);
        }
    }
}
