﻿using System;
using System.Reflection;
using System.Windows.Forms;
using System.IO.Ports;
using Modbus.Device;
using System.Threading;

namespace ModbusExample
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            var asm = Assembly.GetExecutingAssembly();
            Cursor = new Cursor(asm.GetManifestResourceStream("ModbusExample.Resources.HiddenCursor.cur"));
        }

        private volatile bool _stopModbus;
        private Thread _modbusThread;

        private void RunModbus()
        {
            string portName = Environment.OSVersion.Platform == PlatformID.Win32NT ? "COM1" : "/dev/ttyS0";
            SerialPort port = new SerialPort(portName, 115200);
            port.ReadTimeout = 100;
            port.WriteTimeout = 100;
            port.Open();

            _stopModbus = false;

            ModbusSerialMaster master = ModbusSerialMaster.CreateRtu(port);
            IAsyncResult result = null;

            while(!_stopModbus)
            {
                // Read UI's button states and assign to device's outputs
                bool[] outputs = new bool[4];
                result = BeginInvoke(new Action(() =>
                {
                    outputs[0] = button1.IsOn;
                    outputs[1] = button2.IsOn;
                    outputs[2] = button3.IsOn;
                    outputs[3] = button4.IsOn;
                }));

                while (!_stopModbus && !result.IsCompleted)
                {
                    Thread.Yield();
                }

                if (!_stopModbus)
                {
                    try
                    {
                        master.WriteMultipleCoils(1, 32, outputs);
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }
                }

                // Read inputs and assign to UI's Lamps
                if (!_stopModbus)
                {
                    try
                    {
                        var inputs = master.ReadCoils(1, 8, 4);

                        result = BeginInvoke(new Action(() =>
                        {
                            lamp8.IsOn = inputs[3];
                            lamp9.IsOn = inputs[2];
                            lamp10.IsOn = inputs[1];
                            lamp11.IsOn = inputs[0];
                        }));
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }                    
                }

                while (!_stopModbus && !result.IsCompleted)
                {
                    Thread.Yield();
                }
            }

            master.Dispose();

            port.Close();
            port.Dispose();
        }

        private void Form1_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            _modbusThread = new Thread(RunModbus);
            _modbusThread.IsBackground = true;
            _modbusThread.Start();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            _stopModbus = true;
            _modbusThread.Join();
        }
    }
}
