#include <QGuiApplication>
#include <QQmlApplicationEngine>
#include <QThread>
#include <QQuickWindow>

#include "modbusmaster.h"

int main(int argc, char *argv[])
{
    QGuiApplication app(argc, argv);

    QQmlApplicationEngine engine;
    engine.load(QUrl(QStringLiteral("qrc:/main.qml")));

    ModbusMaster modbus(&engine);

    // Wire up the status indicators
    QQuickWindow* window = qobject_cast<QQuickWindow*>(engine.rootObjects()[0]);
    QObject* statusIndicator0 = window->findChild<QObject*>("statusIndicator0");
    QObject* statusIndicator1 = window->findChild<QObject*>("statusIndicator1");
    QObject* statusIndicator2 = window->findChild<QObject*>("statusIndicator2");
    QObject* statusIndicator3 = window->findChild<QObject*>("statusIndicator3");

    QObject::connect(&modbus, &ModbusMaster::input0, [=](bool value){ statusIndicator0->setProperty("active", value);});
    QObject::connect(&modbus, &ModbusMaster::input1, [=](bool value){ statusIndicator1->setProperty("active", value);});
    QObject::connect(&modbus, &ModbusMaster::input2, [=](bool value){ statusIndicator2->setProperty("active", value);});
    QObject::connect(&modbus, &ModbusMaster::input3, [=](bool value){ statusIndicator3->setProperty("active", value);});

    // Wire up the toggle buttons
    QObject* toggleButton0 = window->findChild<QObject*>("toggleButton0");
    QObject* toggleButton1 = window->findChild<QObject*>("toggleButton1");
    QObject* toggleButton2 = window->findChild<QObject*>("toggleButton2");
    QObject* toggleButton3 = window->findChild<QObject*>("toggleButton3");

    QObject::connect(toggleButton0, SIGNAL(click(bool)), &modbus, SLOT(output0(bool)));
    QObject::connect(toggleButton1, SIGNAL(click(bool)), &modbus, SLOT(output1(bool)));
    QObject::connect(toggleButton2, SIGNAL(click(bool)), &modbus, SLOT(output2(bool)));
    QObject::connect(toggleButton3, SIGNAL(click(bool)), &modbus, SLOT(output3(bool)));

    return app.exec();
}
