#ifndef MODBUSMASTER_H
#define MODBUSMASTER_H

#include <QObject>
#include <QTimer>
#include <QtSerialBus/QModbusRtuSerialMaster>
#include <QVariant>

class ModbusMaster : public QObject
{
    Q_OBJECT
    volatile bool m_stop;
    QTimer* m_timer;
    QModbusRtuSerialMaster* m_modbus;

    bool m_output0;
    bool m_output1;
    bool m_output2;
    bool m_output3;

public:
    explicit ModbusMaster(QObject *parent = 0);
    ~ModbusMaster();

signals:
    void input0(bool value);
    void input1(bool value);
    void input2(bool value);
    void input3(bool value);

public slots:
    void run();
    void processRead();
    void processWrite();

    void output0(bool value);
    void output1(bool value);
    void output2(bool value);
    void output3(bool value);
};

#endif // MODBUSMASTER_H
