﻿using System;
using System.Collections.Generic;
using System.IO.Ports;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Client
{
    class Program
    {
        static void Main(string[] args)
        {
            using (SerialPort port = new SerialPort("/dev/serial0", 9600))
            {
                port.ReadTimeout = 1000;
                port.Open();

                Console.WriteLine("Client running on " + port.PortName + " at " + port.BaudRate + "bps");
                Console.WriteLine("Enter commands \"date\" or \"time\" to receive the date and/or time on the server");

                while (true)
                {
                    // Read command from stdin
                    string cmd = Console.ReadLine();

                    // Send command to the server
                    port.Write(cmd + '\n');

                    // Receive resposne from the server
                    string rx = port.ReadTo("\n");
                    Console.WriteLine(rx);
                }
            }
        }
    }
}
