﻿using System;
using System.Collections.Generic;
using System.IO.Ports;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Server
{
    class Program
    {
        static void Main(string[] args)
        {
            using (SerialPort port = new SerialPort("COM1", 9600))
            {
                port.Open();

                Console.WriteLine("Server running on " + port.PortName + " at " + port.BaudRate + "bps");

                string rx = string.Empty;

                while(true)
                {
                    // Read data from client
                    rx = port.ReadExisting();

                    var indexOfNewLine = 1;
                    do
                    {
                        // Each command should end with a '\n'
                        indexOfNewLine = rx.IndexOf('\n');
                        if (indexOfNewLine >= 0)
                        {
                            // parse command from rx
                            var cmd = rx.Substring(0, indexOfNewLine);
                            rx = rx.Substring(indexOfNewLine + 1);

                            // process command
                            Console.WriteLine("Received command \"" + cmd + "\"");
                            if (cmd.ToLower() == "date")
                            {
                                port.Write(DateTime.Now.ToShortDateString() + '\n');
                            }
                            else if (cmd.ToLower() == "time")
                            {
                                port.Write(DateTime.Now.ToShortTimeString() + '\n');
                            }
                            else
                            {
                                Console.WriteLine("Invalid command: " + cmd);
                            }
                        }
                    } while (indexOfNewLine >= 0);
                }
            }
        }
    }
}
