﻿Imports System
Imports System.Linq
Imports System.Collections.Generic
Imports System.ComponentModel
Imports System.Data
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms
Imports System.Threading
Imports Modbus.Device
Imports System.IO.Ports

Public Class Form1

    Private _modbusMaster As ModbusSerialMaster
    Private _serialPort As SerialPort
    Const SLAVE_ADDRESS As Integer = 1


    Private Sub ReportError(ByVal s As String)
        MessageBox.Show(s)
    End Sub

    Private Sub ReadADC()
        Try
            Dim result As UShort() = _modbusMaster.ReadInputRegisters(SLAVE_ADDRESS, 276, 1)
            _adcLabel.Text = result(0).ToString()
        Catch ex As Exception
            ReportError(ex.Message)
        End Try
    End Sub

    Private Sub ReadDigitalOutput()
        Try
            Dim result As Boolean() = _modbusMaster.ReadCoils(SLAVE_ADDRESS, 32, 1)

            If result(0) Then
                _digitalOutLabel.Text = "ON"
            Else
                _digitalOutLabel.Text = "OFF"
            End If

        Catch ex As Exception
            ReportError(ex.Message)
        End Try
    End Sub

    Private Sub WriteDigitalOutput(ByVal [on] As Boolean)
        Try
            _modbusMaster.WriteSingleCoil(SLAVE_ADDRESS, 32, [on])
        Catch ex As Exception
            ReportError(ex.Message)
        End Try
    End Sub

    Private Sub _digitalOutReadButton_Click(ByVal sender As Object, ByVal e As EventArgs) Handles _digitalOutReadButton.Click
        ReadDigitalOutput()
    End Sub

    Private Sub _onButton_Click(ByVal sender As Object, ByVal e As EventArgs) Handles _onButton.Click
        WriteDigitalOutput(True)
    End Sub

    Private Sub _offButton_Click(ByVal sender As Object, ByVal e As EventArgs) Handles _offButton.Click
        WriteDigitalOutput(False)
    End Sub

    Private Sub _adcReadButton_Click(ByVal sender As Object, ByVal e As EventArgs) Handles _adcReadButton.Click
        ReadADC()
    End Sub

    Private Sub Form1_Closing(ByVal sender As Object, ByVal e As CancelEventArgs)
        _modbusMaster.Dispose()
        _modbusMaster = Nothing
        _serialPort.Close()
        _serialPort.Dispose()
        _serialPort = Nothing
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        _serialPort = New SerialPort("COM1", 115200)
        _serialPort.Open()
        _modbusMaster = ModbusSerialMaster.CreateRtu(_serialPort)
        _modbusMaster.Transport.ReadTimeout = 500
        _modbusMaster.Transport.WriteTimeout = 500
        _modbusMaster.Transport.Retries = 0
    End Sub
End Class
