﻿using System;
using System.Reflection;
using System.Windows.Forms;
using System.IO.Ports;
using Modbus.Device;
using System.Threading;

namespace ModbusExample
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            var asm = Assembly.GetExecutingAssembly();
            Cursor = new Cursor(asm.GetManifestResourceStream("ModbusExample.Resources.HiddenCursor.cur"));
        }

        private volatile bool _stopModbus;
        private Thread _modbusThread;
        int count;

        private void RunModbus()
        {
            string portName = Environment.OSVersion.Platform == PlatformID.Win32NT ? "COM1" : "/dev/serial0";
            SerialPort port = new SerialPort(portName, 57600);
            port.ReadTimeout = 50;
            port.WriteTimeout = 50;
            port.Open();

            _stopModbus = false;

            ModbusSerialMaster master = ModbusSerialMaster.CreateRtu(port);
            IAsyncResult result = null;

            while (!_stopModbus)
            {

                result = BeginInvoke(new Action(() =>
                {

                }));

                while (!_stopModbus && !result.IsCompleted)
                {
                    Thread.Yield();
                }


                if (!_stopModbus)
                {
                    try
                    {
                        
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }

                }

                


                // Read ADIN DATA
                if (!_stopModbus)
                {
                    try
                    {
                        var AD_CH = master.ReadHoldingRegisters(1, 100, 4);

                        result = BeginInvoke(new Action(() =>
                        {
                            label11.Text = AD_CH[0].ToString();
                            label12.Text = AD_CH[1].ToString();
                            label13.Text = AD_CH[2].ToString();
                            label14.Text = AD_CH[3].ToString();
                            
                        }));
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }                    
                }
                
                while (!_stopModbus && !result.IsCompleted)
                {
                    Thread.Yield();
                }
                
                try
                {
                    var TEMP_CH = master.ReadHoldingRegisters(1, 300, 4);
                    double[] Ftemp = new double[4];

                    for (int i = 0; i < 4; i++)
                    {
                        Ftemp[i] = Convert.ToDouble(TEMP_CH[i]);
                        if ((Ftemp[i] > 0x8000) )
                        {
                            Ftemp[i] = Ftemp[i] - 0x8000;
                            Ftemp[i] = Ftemp[i] * (-1);
                        }
                        Ftemp[i] = Ftemp[i] / 10.0;
                    }

                    result = BeginInvoke(new Action(() =>
                    {
                        label15.Text = Ftemp[0].ToString();
                        label16.Text = Ftemp[1].ToString();
                        label17.Text = Ftemp[2].ToString();
                        label18.Text = Ftemp[3].ToString();

                    }));


                }

                catch (Exception ex)
                {
                    Console.WriteLine(ex.Message);
                }

                while (!_stopModbus && !result.IsCompleted)
                {
                    Thread.Yield();
                }
            }

            master.Dispose();

            port.Close();
            port.Dispose();
        }

        private void Form1_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            _modbusThread = new Thread(RunModbus);
            _modbusThread.IsBackground = true;
            _modbusThread.Start();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            _stopModbus = true;
            _modbusThread.Join();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}
