﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Windows.Forms;

namespace Comfile.ComfilePi.GPIOTest
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            var asm = Assembly.GetExecutingAssembly();
            Cursor = new Cursor(asm.GetManifestResourceStream("Comfile.ComfilePi.GPIOTest.Resources.hiddencursor.cur"));
        }

        Dictionary<uint, Lamp> _lamps;
        Dictionary<uint, Button> _buttons;

        Thread _pollingThread;
        volatile bool _stopThread = false;

        void PollGPIO()
        {
            while (!_stopThread)
            {
                var result = BeginInvoke(new Action(() =>
                {
                    foreach (var input in GPIO.Inputs)
                    {
                        _lamps[input.Number].IsOn = input.IsOn;
                    }

                    foreach(var output in GPIO.Outputs)
                    {
                        output.IsOn = _buttons[output.Number].IsOn;
                    }
                }));

                while (!_stopThread && !result.IsCompleted)
                {
                    Thread.Sleep(1);
                }
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            _lamps = new Dictionary<uint, Lamp>();
            _lamps.Add(GPIO.Input04.Number, lamp1);
            _lamps.Add(GPIO.Input05.Number, lamp2);
            _lamps.Add(GPIO.Input06.Number, lamp3);
            _lamps.Add(GPIO.Input07.Number, lamp4);
            _lamps.Add(GPIO.Input08.Number, lamp5);
            _lamps.Add(GPIO.Input09.Number, lamp6);
            _lamps.Add(GPIO.Input10.Number, lamp7);
            _lamps.Add(GPIO.Input11.Number, lamp8);
            _lamps.Add(GPIO.Input12.Number, lamp9);
            _lamps.Add(GPIO.Input13.Number, lamp10);
            _lamps.Add(GPIO.Input16.Number, lamp11);

            _buttons = new Dictionary<uint, Button>();
            _buttons.Add(GPIO.Output17.Number, button1);
            _buttons.Add(GPIO.Output18.Number, button2);
            _buttons.Add(GPIO.Output19.Number, button3);
            _buttons.Add(GPIO.Output20.Number, button4);
            _buttons.Add(GPIO.Output21.Number, button5);
            _buttons.Add(GPIO.Output22.Number, button6);
            _buttons.Add(GPIO.Output23.Number, button7);
            _buttons.Add(GPIO.Output24.Number, button8);
            _buttons.Add(GPIO.Output25.Number, button9);
            _buttons.Add(GPIO.Output26.Number, button10);
            _buttons.Add(GPIO.Output27.Number, button11);

            _pollingThread = new Thread(PollGPIO);
            _pollingThread.IsBackground = true;
            _pollingThread.Start();
        }

        private void button12_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            _stopThread = true;
            _pollingThread.Join();
        }

        private void lamp1_Click(object sender, EventArgs e)
        {

        }

        private void label3_Click(object sender, EventArgs e)
        {

        }
    }
}
