﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Comfile.ComfilePi
{
    public static class GPIO
    {
        static readonly int _pi;

        static GPIO()
        {
            AppDomain.CurrentDomain.ProcessExit += CurrentDomain_ProcessExit;

            _pi = pigpio.pigpio_start(IntPtr.Zero, IntPtr.Zero);
        }

        private static void CurrentDomain_ProcessExit(object sender, EventArgs e)
        {
            pigpio.pigpio_stop(_pi);
        }

        #region Inputs
        static readonly Input _input04 = new Input(_pi, 4);
        public static Input Input04
        {
            get { return _input04; }
        }

        static readonly Input _input05 = new Input(_pi, 5);
        public static Input Input05
        {
            get { return _input05; }
        }

        static readonly Input _input06 = new Input(_pi, 6);
        public static Input Input06
        {
            get { return _input06; }
        }

        static readonly Input _input07 = new Input(_pi, 7);
        public static Input Input07
        {
            get { return _input07; }
        }

        static readonly Input _input08 = new Input(_pi, 8);
        public static Input Input08
        {
            get { return _input08; }
        }

        static readonly Input _input09 = new Input(_pi, 9);
        public static Input Input09
        {
            get { return _input09; }
        }

        static readonly Input _input10 = new Input(_pi, 10);
        public static Input Input10
        {
            get { return _input10; }
        }

        static readonly Input _input11 = new Input(_pi, 11);
        public static Input Input11
        {
            get { return _input11; }
        }

        static readonly Input _input12 = new Input(_pi, 12);
        public static Input Input12
        {
            get { return _input12; }
        }

        static readonly Input _input13 = new Input(_pi, 13);
        public static Input Input13
        {
            get { return _input13; }
        }

        static readonly Input _input16 = new Input(_pi, 16);
        public static Input Input16
        {
            get { return _input16; }
        }

        static readonly Input[] _inputs = new Input[]
        {
            _input04,
            _input05,
            _input06,
            _input07,
            _input08,
            _input09,
            _input10,
            _input11,
            _input12,
            _input13,
            _input16
        };
        public static ReadOnlyCollection<Input> Inputs
        {
            get { return Array.AsReadOnly(_inputs); }
        }

        #endregion Inputs

        #region Outputs
        static readonly Output _output17 = new Output(_pi, 17);
        public static Output Output17
        {
            get { return _output17; }
        }

        static readonly Output _output18 = new Output(_pi, 18);
        public static Output Output18
        {
            get { return _output18; }
        }

        static readonly Output _output19 = new Output(_pi, 19);
        public static Output Output19
        {
            get { return _output19; }
        }

        static readonly Output _output20 = new Output(_pi, 20);
        public static Output Output20
        {
            get { return _output20; }
        }

        static readonly Output _output21 = new Output(_pi, 21);
        public static Output Output21
        {
            get { return _output21; }
        }

        static readonly Output _output22 = new Output(_pi, 22);
        public static Output Output22
        {
            get { return _output22; }
        }

        static readonly Output _output23 = new Output(_pi, 23);
        public static Output Output23
        {
            get { return _output23; }
        }

        static readonly Output _output24 = new Output(_pi, 24);
        public static Output Output24
        {
            get { return _output24; }
        }

        static readonly Output _output25 = new Output(_pi, 25);
        public static Output Output25
        {
            get { return _output25; }
        }

        static readonly Output _output26 = new Output(_pi, 26);
        public static Output Output26
        {
            get { return _output26; }
        }

        static readonly Output _output27 = new Output(_pi, 27);
        public static Output Output27
        {
            get { return _output27; }
        }

        static readonly Output[] _outputs = new Output[] 
        {
            _output17,
            _output18,
            _output19,
            _output20,
            _output21,
            _output22,
            _output23,
            _output24,
            _output25,
            _output26,
            _output27,
        };
        public static ReadOnlyCollection<Output> Outputs
        {
            get { return Array.AsReadOnly(_outputs); }
        }
        #endregion Outputs
    }
}
