﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;

namespace Comfile.ComfilePi
{
    internal static class pigpio
    {
        const string libraryPath = "libpigpiod_if2.so";

        public const uint PI_INPUT = 0;
        public const uint PI_OUTPUT = 1;

        public const uint PI_PUD_UP = 0;
        public const uint PI_PUD_DOWN = 1;
        public const uint PI_PUD_OFF = 2;

        [DllImport(libraryPath)]
        public static extern int pigpio_start(IntPtr addrStr, IntPtr portStr);

        [DllImport(libraryPath)]
        public static extern int pigpio_stop(int pi);

        [DllImport(libraryPath)]
        public static extern int set_mode(int pi, uint gpio, uint mode);

        [DllImport(libraryPath)]
        public static extern int gpio_write(int pi, uint gpio, uint level);

        [DllImport(libraryPath)]
        public static extern int gpio_read(int pi, uint gpio);

        [DllImport(libraryPath)]
        public static extern int set_pull_up_down(int pi, uint gpio, uint pud);
    }
}
