﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Device.I2c;
using System.Threading.Tasks;
using System.Threading;
using System.Diagnostics;

namespace ComfileTech.ComfilePi.IO
{
    public class ADS1115 : I2CDevice
    {
        public enum ChannelBits
        {
            b00 = 0b00,
            b01 = 0b01,
            b10 = 0b10,
            b11 = 0b11
        }

        const byte CONVERSION = 0x00;
        const byte CONFIG = 0x01;

        public ADS1115()
            : base(0x48)
        { }

        public void ScheduleRead(ChannelBits c)
        {
            var byte0 = (byte)((1 << 7)      // Start conversion
                | (1 << 6)                   // non-differential
                | ((int)c << 4)              // channel
                | (0b000 << 1)               // 6.144V
                | 1);                        // Single-shot

            var byte1 = (byte)((0b100 << 5)  // 128SPS
                | (0 << 4)
                | (0 << 3)
                | (0 << 2)
                | 0b11);                     // Disable comparator

            Write(CONFIG, byte0, byte1);
        }

        public bool IsReady()
        {
            if (Environment.OSVersion.Platform != PlatformID.Unix)
            {
                return true;
            }

            var config = Read(CONFIG);
            return (config & 0b1000_0000) != 0;
        }

        public ushort ReadValue()
        {
            while(!IsReady())
            { }

            var buffer = new byte[2];
            Read(CONVERSION, buffer);
            Array.Reverse(buffer);
            return BitConverter.ToUInt16(buffer, 0);
        }

        public ushort Read(ChannelBits c)
        {
            ScheduleRead(c);
            return ReadValue();
        }
    }
}
