﻿using System;
using System.Collections.Generic;
using System.Device.Gpio;
using System.Text;

namespace ComfileTech.ComfilePi.IO
{
    public abstract class DigitalPin : IDisposable
    {
        private protected DigitalPin(Pin pin, PinMode mode)
        {
            _pin = pin;
            _mode = mode;
            if (Environment.OSVersion.Platform == PlatformID.Unix)
            {
                _gpio = new GpioController(); 
                _gpio.OpenPin((int)_pin, _mode);
            }
        }

        readonly Pin _pin;
        public Pin Pin => _pin;

        readonly PinMode _mode;
        public PinMode Mode => _mode;

        GpioController _gpio;

        public bool State
        {
            get
            {
                if (Environment.OSVersion.Platform == PlatformID.Unix)
                {
                    return _gpio.Read((int)_pin) == PinValue.High;
                }

                return false;
            }
            private protected set
            {
                if (Environment.OSVersion.Platform == PlatformID.Unix)
                {
                    if (_mode == PinMode.Output)
                    {
                        _gpio.Write((int)_pin, value ? PinValue.High : PinValue.Low);
                    }
                }
            }
        }

        #region IDisposable Support
        private bool _isDisposed = false;

        private protected virtual void Dispose(bool disposing)
        {
            
        }

        void _dispose(bool disposing)
        {
            if (!_isDisposed)
            {
                Dispose(disposing);

                if (disposing)
                {
                    if (Environment.OSVersion.Platform == PlatformID.Unix)
                    {
                        _gpio.Dispose();
                    }
                }

                _gpio = null;

                _isDisposed = true;
            }
        }

        public void Dispose()
        {
            _dispose(true);
        }
        #endregion
    }
}
