﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Device.I2c;
using System.Runtime.InteropServices;

namespace ComfileTech.ComfilePi.IO
{
    public class I2CDevice : IDisposable
    {
        protected I2CDevice(byte address)
        {
            if (Environment.OSVersion.Platform == PlatformID.Unix)
            {
                _i2c = I2cDevice.Create(new I2cConnectionSettings(1, address));
            }
        }

        I2cDevice _i2c;

        protected void Read(Span<byte> buffer)
        {
            if (Environment.OSVersion.Platform == PlatformID.Unix)
            {
                _i2c.Read(buffer);
            }
        }

        protected byte Read()
        {
            if (Environment.OSVersion.Platform == PlatformID.Unix)
            {
                return _i2c.ReadByte();
            }
            return 0;
        }

        protected byte Read(byte address)
        {
            Write(address);
            return Read();
        }

        protected void Read(byte address, Span<byte> buffer)
        {
            Write(address);
            Read(buffer);
        }

        protected void Write(Span<byte> buffer)
        {
            if (Environment.OSVersion.Platform == PlatformID.Unix)
            {
                _i2c.Write(buffer);
            }
        }

        protected void Write(params byte[] bytes)
        {
            Write((Span<byte>)bytes);
        }

        #region IDisposable Support
        private bool disposedValue = false;

        protected virtual void Dispose(bool disposing)
        {
            if (!disposedValue)
            {
                if (disposing)
                {
                    if (Environment.OSVersion.Platform == PlatformID.Unix)
                    {
                        _i2c.Dispose();
                    }
                }

                _i2c = null;

                disposedValue = true;
            }
        }

        public void Dispose()
        {
            Dispose(true);
        }
        #endregion
    }
}
