from smbus2 import SMBus
import time
CF3_I2C = 3
CF2_I2C = 1
CF1_I2C = 0

################################## CF_SCANNER ############################################
class CFNETScanner:
    def __init__(self, i2c_ch: int, start_addr:int, length: int):
        self.i2c_ch = i2c_ch
        self.start_addr = start_addr
        self.length = length

    def scan(self, method: str = "read"):
        #"read" / "quick" : read_byte / write_quick 로 ACK 확인
        found = []
        end_addr = self.start_addr + self.length  # end는 포함 안 됨(range 규칙)

        with SMBus(self.i2c_ch) as i2c:
            for address in range(self.start_addr, end_addr):
                try:
                    if method == "quick": i2c.write_quick(address)
                    else:                 i2c.read_byte(address)
                    found.append(address)
                    #print(f"{found[address-self.start_addr]:x}")    #디버그
                except OSError: pass
        return found
    
################################## CFNET3 ############################################
class Cfnet3():
    CFDO_ADDR = (0x20)
    IODIRA = (0x00)   # A포트 방향 제어 (1: 입력, 0: 출력)
    IODIRB = (0x01)   # B포트 방향 제어
    OLATA  = (0x14)    # A포트 출력 레지스터
    OLATB  = (0x15)    # B포트 출력 레지스터
    
    def __init__(self):
        self.idscan3 = CFNETScanner(CF3_I2C, self.CFDO_ADDR, 8)
        self.CFNET3_SCAN = self.idscan3.scan("read")
        #print(f"scan3 : {self.CFNET3_SCAN}")   #디버그
        with SMBus(CF3_I2C) as cfnet3:
            for i in self.CFNET3_SCAN:
                if i in range(self.CFDO_ADDR, self.CFDO_ADDR+8):
                    cfnet3.write_i2c_block_data(i, self.IODIRA, [0x00, 0x00])# 모드 출력
                    cfnet3.write_i2c_block_data(i, self.OLATA,  [0x00, 0x00])# 출력off
        
    
    def cfdoWrite(self, id, value):
        ldata = value & 0xff
        hdata = (value >> 8) &0xff

        if self.CFDO_ADDR + id in self.CFNET3_SCAN :
            try:
                with SMBus(CF3_I2C) as cfnet3 :
                    cfnet3.write_i2c_block_data(self.CFDO_ADDR+ id, self.OLATA, [ldata, hdata])
            except: pass
        
################################## CFNET2 ############################################     
class Cfnet2 ():
    CFDI_ADDR = (0x20)
    def __init__(self):
        self.idscan2 = CFNETScanner(CF2_I2C, self.CFDI_ADDR, 8)
        self.CFNET2_SCAN = self.idscan2.scan("read")
        #print(f"scan2 : {self.CFNET2_SCAN}")   #디버그
        
    def cfdiRead(self, id):
        try : 
            with SMBus(CF2_I2C) as cfnet2 :
                data = cfnet2.read_i2c_block_data(self.CFDI_ADDR + id, 0xff, 2)
        except : pass

        #print(f"in_value_data :{data[1]:x} {data[0]:x}")#디버그
        return data  
################################## CFNET1 ############################################     
class Cfnet1():
    CFADCA4L_ID = (0X48)  #72
    CFDAC2V_ID  = (0X58)  #88
    CFTC_ID     = (0X60)
    
    CFADC_SCAN = []
    CFDAC2V_SCAN = []
    CFTC_SCAN = []
    
    def __init__(self):
        #ADC SCAN
        self.idscan1 = CFNETScanner(CF1_I2C, self.CFADCA4L_ID, 4) 
        self.CFADC_SCAN = self.idscan1.scan("read")
        #DAC SCAN
        self.idscan1 = CFNETScanner(CF1_I2C, self.CFDAC2V_ID, 8)  
        self.CFDAC2V_SCAN = self.idscan1.scan("read")
        #TC SCAN
        self.idscan1 = CFNETScanner(CF1_I2C, self.CFTC_ID, 8)
        self.CFTC_SCAN = self.idscan1.scan("read")
        
        #print(f"ADC_scan1 : {self.CFADC_SCAN}")   #디버그
        #print(f"DAC_scan1 : {self.CFDAC2V_SCAN}")   #디버그
        #print(f"TC_ scan1 : {self.CFTC_SCAN}")   #디버그
    #CFDAC-2V 초기화--------------------------------------------------------------                   
        for i in range(self.CFDAC2V_ID, self.CFDAC2V_ID+8):
            if i in self.CFDAC2V_SCAN:
                try : 
                    with SMBus(CF1_I2C) as cfnet1 :
                        cfnet1.write_i2c_block_data(i, 0x01, [0x11])        #0-10v mode 
                        cfnet1.write_i2c_block_data(i, 0x02, [0x00, 0x00])  #ch0 초기화
                        cfnet1.write_i2c_block_data(i, 0x04, [0x00, 0x00])  #ch1 초기화
                except : pass
#CFDAC-2V --------------------------------------------------------------------------           
    def cfdacWrite(self, id, channel, data):
        if data > 4095 : data =4095
        elif data<0 : data = 0
        if channel == 0 :ch = 0x02
        else :ch = 0x04
        
        msb = ( data & 0x0f ) << 4
        lsb = ( data >> 4 ) & 0xff
        try:
            with SMBus(CF1_I2C) as cfnet1 :
                cfnet1.write_i2c_block_data(self.CFDAC2V_ID + id ,ch ,([ msb, lsb ]) )
        except : pass
#CFADC-A4L -----------------------------------------------------------    
    def cfadcRead(self, id, channel):
        ADDR = self.CFADCA4L_ID + id
        CONVERSION = 0x00
        CONFIG = 0x01
        config = ( 
          (1 << 15)               # Start conversion  
        | (1 << 14)               # non-differential
        | (channel << 12)         # channel select
        | (0b000 << 9)            # PGA ±6.144V
        | (1 << 8)                # Single-shot mode
        | (0b101 << 5)            # 128 SPS
        | (0 << 4)                # Disable comparator queue
        | (0 << 3)
        | (0 << 2)
        | (0b11)                  # Comparator disable
                )   
        # config write 
        config_high = (config >> 8) & 0xFF
        config_low = config & 0xFF 
        
        with SMBus(CF1_I2C) as cfnet1 :
            try: 
                cfnet1.write_i2c_block_data(ADDR , CONFIG,([config_high, config_low ]) )
            except: pass    
        # Wait for conversion to complete
            while True:
                try:
                    busy= cfnet1.read_byte(ADDR)
                except:pass
                if busy & 0b10000000:
                    break

            #---------------------------------------------------------------
            try: 
                adData_buf = cfnet1.read_word_data(ADDR, CONVERSION)
            except:pass
            adData = ((adData_buf & 0xFF) << 8) | (adData_buf >> 8)
            return adData 
        
#####################################################################################
################################## CFNET ############################################
#####################################################################################
class CFNET(Cfnet3, Cfnet2, Cfnet1):
    OUT_VALUE = [0]*8
    IN_VALUE  = [0]*8
    def __init__(self):
        Cfnet1.__init__(self)
        Cfnet2.__init__(self)
        Cfnet3.__init__(self)
        
#CFDO --------------------------------------------------------------
    def digitalWrite(self, address, data=0, pin=None, on_off=None):
        if (pin == None) and (on_off==None) :
            self.OUT_VALUE[address] = data
            self.cfdoWrite(address, self.OUT_VALUE[address])
        else : 
            if(pin == None) or (on_off== None) : return
            if on_off > 0:
                self.OUT_VALUE[address] |= (0x0001 << pin)
            else :
                self.OUT_VALUE[address]  &= ~(0x0001 << pin)
            self.cfdoWrite(address, self.OUT_VALUE[address])
#CFDI --------------------------------------------------------------        
    def digitalRead(self, address, Pin=None):
        if self.CFDI_ADDR + address in self.CFNET2_SCAN : 
            value = self.cfdiRead(address)
            indata = (value[1]<<8) | value[0]
            if indata is None:    # 통신 실패 전상태값 반환
                indata = self.IN_VALUE[address]
            # indata 가 정상릴 때만 할당
            self.IN_VALUE[address] = indata
            if Pin == None :
                indata = 0xFFFF & ~indata
                return indata
            else :
                if (indata & (0x0001 << Pin)) : return 0
                else : return 1;
        else : return 0    
#CFDAC --------------------------------------------------------------   
    def analogWrite(self, address, channel, data):        
        if (self.CFDAC2V_ID + address) in self.CFDAC2V_SCAN :
            self.cfdacWrite(address, channel, data)
        else : pass
#CFADC --------------------------------------------------------------      
    def analogRead(self, address, channel):        
        if(self.CFADCA4L_ID +address)in self.CFADC_SCAN : 
            data = self.cfadcRead(address, channel)
            return data
        else : return 0
        
