
import sys
import os
from PyQt5.QtWidgets import *
from PyQt5.QtGui import QPixmap
from PyQt5.QtCore import *
from PyQt5 import uic
from CFRASP import CFNET

# 파일 절대경로 (현재 디렉토리 기준)
current_dir = os.path.dirname(os.path.abspath(__file__))

# UI 파일 절대경로 (현재 디렉토리 기준)
ui_path = os.path.join(current_dir, "HMI_design_cfdi(test).ui")
form_class = uic.loadUiType(ui_path)[0]

# 이미지 파일 절대경로 (현재 디렉토리 기준)
ON_IMG = os.path.join(current_dir, "ON.png")
OFF_IMG = os.path.join(current_dir, "OFF.png")



cfnet = CFNET()

class MyWindow(QMainWindow, form_class):
    def __init__(self):
        super().__init__()      
        self.setupUi(self)      
        #타이머 설정
        self.timer = QTimer(self)
        self.timer.setInterval(300)
        self.timer.timeout.connect(self.update_value)
        self.timer.start()
        #초기 cfdio 상태
        self.outport_state = False
        self.inport_state = False
        self.port_OUT_0.clicked.connect(self.CFDO_0_click)
    
    # 입력 업데이트 (INPUT LAMP)           
    def update_value(self):
        ###### !! CFNET CFDI 모듈 입력상태 읽기 !!######
        self.inport_state = cfnet.digitalRead(0, Pin=0)  
        ###############################################
        if self.inport_state == False:
            self.lamp_IN_0.setPixmap(QPixmap(OFF_IMG))
        else :
            self.lamp_IN_0.setPixmap(QPixmap(ON_IMG))

    # 출력 버튼 클릭 이벤트                
    def CFDO_0_click(self):
        self.outport_state = not self.outport_state
        ###### !!     CFNET CFDO port 0 쓰기   !!######
        cfnet.digitalWrite(0, pin =0, on_off= self.outport_state)
        ###############################################
        if self.outport_state == True:
            self.lamp_OUT_0.setPixmap(QPixmap(ON_IMG))
        else:
            self.lamp_OUT_0.setPixmap(QPixmap(OFF_IMG))

        
if __name__ == "__main__":
    print("Start Application")
    app = QApplication(sys.argv)       
    mywindow = MyWindow()              
    mywindow.show()                    
    app.exec_()                 
    