
import sys
import os
from PyQt5.QtWidgets import *
from PyQt5.QtGui import QPixmap
from PyQt5.QtCore import *
from PyQt5 import uic
from CFRASP import CFNET

# 파일 절대경로 (현재 디렉토리 기준)
current_dir = os.path.dirname(os.path.abspath(__file__))
# 이미지 파일 절대경로 (현재 디렉토리 기준)
ON_IMG = os.path.join(current_dir, "ON.png")
OFF_IMG = os.path.join(current_dir, "OFF.png")
ON_OUT_IMG = os.path.join(current_dir, "Out_Lamp_on.png")
OFF_OUT_IMG = os.path.join(current_dir, "Out_Lamp_off.png")
# UI 파일 절대경로 (현재 디렉토리 기준)
ui_path = os.path.join(current_dir, "HMI_design_cfdio(test).ui")
form_class = uic.loadUiType(ui_path)[0]
#form_class = uic.loadUiType("HMI_design_cfdi(test).ui")[0] # ui 파일  경로지정

cfnet = CFNET()


class MyWindow(QMainWindow, form_class):
    def __init__(self):
        super().__init__()      
        self.setupUi(self) 
                  
        #타이머 설정
        self.timer = QTimer(self)
        self.timer.setInterval(300)
        self.timer.timeout.connect(self.update_value)
        self.timer.start()
        #초기 cfdio 상태
        self.cfdi_state = 0x0000
        self.cfdo_state = 0x0000
        # 묶기
        self.LAMP_STATE = [False]*16
        self.IN_LAMPS = [
            self.lamp_IN_0,self.lamp_IN_1,self.lamp_IN_2,self.lamp_IN_3,
            self.lamp_IN_4,self.lamp_IN_5,self.lamp_IN_6,self.lamp_IN_7,
            self.lamp_IN_8,self.lamp_IN_9,self.lamp_IN_10,self.lamp_IN_11,
            self.lamp_IN_12,self.lamp_IN_13,self.lamp_IN_14,self.lamp_IN_15
        ]        
        self.OUT_LAMPS = [
            self.lamp_OUT_0,self.lamp_OUT_1,self.lamp_OUT_2,self.lamp_OUT_3,
            self.lamp_OUT_4,self.lamp_OUT_5,self.lamp_OUT_6,self.lamp_OUT_7,
            self.lamp_OUT_8,self.lamp_OUT_9,self.lamp_OUT_10,self.lamp_OUT_11,
            self.lamp_OUT_12,self.lamp_OUT_13,self.lamp_OUT_14,self.lamp_OUT_15
        ]        
        self.OUT_BUTTONS = [
            self.port_OUT_0,self.port_OUT_1,self.port_OUT_2,self.port_OUT_3,
            self.port_OUT_4,self.port_OUT_5,self.port_OUT_6,self.port_OUT_7,
            self.port_OUT_8,self.port_OUT_9,self.port_OUT_10,self.port_OUT_11,
            self.port_OUT_12,self.port_OUT_13,self.port_OUT_14,self.port_OUT_15
        ]
        # 버튼 클릭 시그널 연결
        for idx, btn in enumerate(self.OUT_BUTTONS):
            btn.clicked.connect(( lambda _, i=idx:self.CFDO_1_click(i) ) )
        
    # 업데이트 값 (VLAUE, INPUT LAMP)           
    def update_value(self):
        
        ###### !! CFNET CFDI 모듈 입력상태 읽기 !!######
        self.cfdi_state = cfnet.digitalRead(0)  
        ###############################################
        
        self.CFDO_1_Value.setText(f"{self.cfdo_state:04X}")
        self.CFDI_0_Value.setText(f"{self.cfdi_state:04X}")
        
        for index in range(16):
            if self.cfdi_state & (1 << index):
                self.IN_LAMPS[index].setPixmap(QPixmap(ON_IMG))
            else:
                self.IN_LAMPS[index].setPixmap(QPixmap(OFF_IMG))
    
    # 출력 버튼 클릭 이벤트                
    def CFDO_1_click(self, index):

        self.LAMP_STATE[index] = not self.LAMP_STATE[index]
        self.cfdo_state = self.cfdo_state ^ (1 << index)
        
        ###### !! CFNET CFDO 모듈 출력제어 쓰기 !! ######
        cfnet.digitalWrite(0, self.cfdo_state)
        ###############################################
        
        if self.LAMP_STATE[index]:
            self.OUT_LAMPS[index].setPixmap(QPixmap(ON_OUT_IMG))
        else:
            self.OUT_LAMPS[index].setPixmap(QPixmap(OFF_OUT_IMG))
        

if __name__ == "__main__":
    print("Start Application")
    app = QApplication(sys.argv)       
    mywindow = MyWindow()              
    mywindow.show()                    
    app.exec_()                 
    